# Player Config ID: huggingface_DeepSeek-V3-0324_PayoffMaximizer_A (as Player A)
# Meta-Round: 1
# Experiment: PMxPM, Run: 1
# API: huggingface, Model: deepseek-ai/DeepSeek-V3-0324
# Based on textual strategy: huggingface_DeepSeek-V3-0324_PayoffMaximizer_A_MR1_strategy.txt
# LLM Suggested Fallback: C

def friendly_neighbor(my_history: list, opp_history: list, opponent_program_code: str) -> str:
    if not opp_history:
        return "C"
    
    if "always \"D\"" in opponent_program_code or "always 'D'" in opponent_program_code:
        return "D"
    
    if "always \"C\"" in opponent_program_code or "always 'C'" in opponent_program_code:
        return "C"
    
    if len(opp_history) >= 8 and any(move == "D" for move in opp_history):
        return "D"
    
    return opp_history[-1]